-- Sucht für die angegebenen ab2s über die in diesen enthaltenen resourcen die resource mit der kürzesten durchlaufzeit (zB 5 AG unterschiedlicher ABK mit Kostenstelle MON sollen alle zusammenhängend terminiert werden)
SELECT tsystem.function__drop_by_regex( 'abk__termination_ab2s__as__block__by__a2_ids', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__termination_ab2s__as__block__by__a2_ids(
      IN  _a2ids int[],
         -- Zeitpunkt, ab dem terminiert werden soll
          -- NULL: nimmt das Datum des Vor-AG (siehe bei greatest unten)
      IN  _direction  varchar   DEFAULT 'forward',
      IN  _start_date timestamp DEFAULT null,
      IN  _checkBlockedTimes bool = true,             -- Bei 'false' DLZ-Terminierung: Ignoriert Blockierungen auf der Ressource durch andere Task*-Einträge. Es werden nur Off-Times beachtet.
      IN  _allow_overlap bool = false,                -- Überlappungen bei der Terminierung von Arbeitsgängen innerhalb der gleichen ABK erlauben.
      IN  _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' ),
      OUT resource_id integer,
      OUT slot_start  timestamp,
      OUT slot_end    timestamp
      )
      RETURNS record
      AS $$
      DECLARE
          _forward bool;
          _earliest_start_date__forward timestamp;
          _earliest_start_date__backward timestamp;
      BEGIN
          IF _direction IS null THEN
             _direction := 'forward'; -- Oberfläche übergibt hart null
          END IF;

          IF _direction = 'forward' THEN
            _forward              := true;
          ELSE
            _forward              := false;
          END IF;          

          RAISE NOTICE '%', format(
                                   $call$
                                             SELECT scheduling.abk__termination_ab2s__as__block__by__a2_ids(
                                                   _a2ids => %L,
                                                   _direction => %L,
                                                   _start_date => %L,
                                                   _checkBlockedTimes => %L,
                                                   _allow_overlap => %L,
                                                   _loglevel => %L
                                             )
                                   $call$,
                                   _a2ids,
                                   _direction,
                                   _start_date,
                                   _checkBlockedTimes,
                                   _allow_overlap,
                                   _loglevel
                                  );

          -- RAISE NOTICE '%;%', array_agg(a2w_resource_id_main_fix), array_agg(resource.context_id) FROM ab2_wkstplan JOIN scheduling.resource ON id = a2w_resource_id_main_fix AND context = 'ksvba' WHERE a2w_a2_id = ANY(_a2ids) ;

          WITH
            _a2 AS (
            -- alle AG's zu den angegebenen ABK holen. abkx, a2ids
              SELECT -- a2_n, -- siehe unten auskommentiertes GROUP BY
                     array_agg( a2_ab_ix )  AS abks,
                     array_agg( a2_id )     AS a2_ids,
                     -- NOTE AXS: Hier KEINEN zusätzlichen Puffer addieren! Da sonst bei "Vorwärts und Packen" bei der Rückwärtsterminierung (dem Packen) der gleiche Slot für die Gruppe nicht mehr gefunden wird. 
                     -- dies passiert, da der puffer vom nächsten AG wieder "weggelassen" wird, der nächste AG rückt heran. Dadurch kann im Netzplan beim Rückwärts terminieren dann in die Vergangenheit geraten werden!
                     -- Puffer in Funktion scheduling.resource_timeline__abk_ab2__termination__grouped() addieren.
                     sum( scheduling.ab2__required_worktime__get( ab2 ) )                              AS worktime,
                     max( IFTHEN(_allow_overlap, null::timestamp without time zone, ab2p.a2_et) )        AS earliest_start_date__forward, -- max(a2_et) der Vorgänger  (vorwärts)
                     min( IFTHEN(_allow_overlap, null::timestamp without time zone, ab2n.a2_at) )        AS earliest_start_date__backward -- min(a2_at) der Nachfolger (rückwärts)
                FROM ab2
                LEFT JOIN scheduling.resource_timeline ON ti_a2_id = a2_id
               CROSS JOIN LATERAL ( (SELECT (scheduling.ab2__prior__terminated__get(ab2)).a2_et) ) ab2p
               CROSS JOIN LATERAL ( (SELECT (scheduling.ab2__next__terminated__get(ab2)).a2_at) ) ab2n
               WHERE a2_id = any(_a2ids)

               -- GROUP BY a2_n --?? => nein. Sonst kann man zB nicht innerhalb einer ABK 2 aufeinanderfolgende AG zusammenhalten
            ),

            -- die Anzahl der verschiedenen AG zählen
            _cnt_a2_ids AS (
              SELECT count( DISTINCT a2_id ) AS cnt
                FROM _a2
                CROSS JOIN LATERAL unnest( _a2.a2_ids ) AS a2_id
            ),
            -- die möglichen Resourcen welche für die Terminierung in Frage kommen.
            -- dazu aus der bereits ermittelten Liste von ab2s entsprechend die resource_requirements holen (ids der resourcen)

            _resource_options AS (
                SELECT r.id AS resource_id, factor_tm_ta
                  FROM _a2 -- a2_ids-Array pro a2_n
                 CROSS JOIN LATERAL unnest( _a2.a2_ids ) AS a2_id -- a2_ids-Array in mehrere Zeilen aufsplitten
                 CROSS JOIN LATERAL coalesce( ( SELECT array_agg(resource.context_id) FROM ab2_wkstplan JOIN scheduling.resource ON id = a2w_resource_id_main_fix AND context = 'ksvba' WHERE a2w_a2_id = a2_id ) -- wir bleiben bevorzugt auf der bereits terminierten Resource bzw. auf die, welche der Nutzer gerade (Drag/Drop) fixiert hat!
                                            , ( SELECT ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get FROM scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( a2_id ) )
                                            ) AS ksb_ids -- alle möglichen Arbeitsplätze (ksb_ids) für jeweilige a2_id ermittlen  -- TODO AXS nur in abk hinterlegte, nicht aus ASK! Neue Funktion für alle in aktuellen Optionen
                 CROSS JOIN LATERAL unnest( ksb_ids ) AS ksb_id -- ksb_ids-Array in mehrere Zeilen aufsplitten --- TODO DISTINCT???
                       JOIN         scheduling.resource r ON r.context = 'ksvba' AND r.context_id = ksb_id -- ksb_id in resource_id übersetzen
                 CROSS JOIN LATERAL scheduling.ab2__factor_tm_ta__get( a2_id ) AS factor_tm_ta
                 GROUP BY r.id, factor_tm_ta
                HAVING count( DISTINCT a2_id ) >= ( SELECT cnt FROM _cnt_a2_ids ) -- Gleiche Ressource-IDs bzw. Arbeitsplatz-IDs zusammenfassen dabei nur Schnittmenge der Ressourcen-IDs aller gegebenen AGe zurückgeben
            )
          -- Nun aus den gesammelten Daten terminieren.
          SELECT _resource_options.resource_id,
                 slots.slot_start,
                 slots.slot_end,
         
                 -- debug
                 earliest_start_date__forward,
                 earliest_start_date__backward
         
                 --,*
                 --,(scheduling.resource__translate__resource_id__to__ksvba__shorthand(resource_id)).ksb_ks_shorthand
            INTO resource_id,
                 slot_start,
                 slot_end,
         
                 -- debug
                 _earliest_start_date__forward,
                 _earliest_start_date__backward
         
            FROM _a2
            JOIN _resource_options ON true
            JOIN LATERAL (
                      SELECT min( slots.slotstartdate ) AS slot_start,
                             max( slots.slotenddate )   AS slot_end
                        FROM scheduling.resource_timeline__timeslots__search(
                                      _resource_id        => _resource_options.resource_id,
                                      _time_required      => _a2.worktime,
                                      _load_required      => 1,
                                      _timeframe_start    =>  CASE WHEN _forward THEN
                                                                  -- vorwärts terminieren: Ende Vorarbeitsgang, Nutzereingabe oder heute
                                                                  (greatest( _a2.earliest_start_date__forward, _start_date,  now() ) )
                                                              ELSE      -- rückwärts terminieren: Anfang maximal heute
                                                                  (_start_date - '1 year'::interval)
                                                              END ::timestamp,
                                      _timeframe_end      =>  CASE WHEN _forward THEN
                                                                  (greatest( _a2.earliest_start_date__forward, _start_date, now() ) + '1 year'::interval)
                                                              ELSE
                                                                  (least( _a2.earliest_start_date__backward, _start_date) )
                                                              END ::timestamp,
                                      _direction          => _direction,
                                      _factor_tm_ta       => _resource_options.factor_tm_ta,
                                      _checkBlockedTimes  => NOT scheduling.resource__is_auswaerts( _resource_options.resource_id ) AND _checkBlockedTimes, -- DLZ!
                                      _loglevel           => _loglevel
                                      ) AS slots
                      ) AS slots ON true
           -- WHERE slots.slot_start IS NOT null
           ORDER BY CASE WHEN _forward THEN -- Vorwärts => sortiert nach frühestem Ende-Zeitpunkt aufsteigend
                              slots.slot_end
                    END ASC NULLs LAST,
                    CASE WHEN not _forward THEN -- Rückwärts
                              slots.slot_start
                    END DESC NULLs FIRST
           LIMIT 1
          ;

          RAISE NOTICE 'scheduling.abk__termination_ab2s__as__block__by__a2_ids: _earliest_start_date__forward: "%" - _earliest_start_date__backward:"%"', _earliest_start_date__forward, _earliest_start_date__backward;          

          IF ( resource_id IS null ) THEN
              RAISE EXCEPTION 'scheduling.abk__termination_ab2s__as__block__by__a2_ids:% Es gibt keine gemeinsamen Arbeitsplätze für die Liste der übergebenen Arbeitsgänge. xtt32006', _a2ids;
          END IF;
      
        RETURN;
      END $$ LANGUAGE plpgsql;